// CSugDict.cp
// CSugDict.h
// ----------------------------------------------------------------------------------
// The automatic change dictionary class.
//
// This dictionary automatically changes a word to an other word.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
//		Clark Goble			09/02/94
//			Original.
// ----------------------------------------------------------------------------------

#ifndef _CSUGDICT_
#define _CSUGDICT_

#include "UBloom.h"
#include "CDict.h"
#include "UExtend.h"


typedef struct	SugList {	
	char	*toChange;
	char	*Correction;
	char	*Comment;
	struct SugList	*next;
} SugList;


class CSugDict: public CDict, UExtended
{
public:
	CSugDict(long NumBuffers, FioParam * theFile);
	virtual ~CSugDict();
	
	short		Check(char *Word);
	short		Find(char *Word);
	short		Current(char *Word, char *change, char *comment);
	short		Next(char *Word, char *change, char *comment);
	
	
	short 	Add(char *Word, char *change, char *comment);
private:
	
	SugList	*theList;	// list of suggestions
	SugList	*LastFound;	// last found suggestion
	
	Uio	*DictFile;	// the physical data file
	UBloom	*WordList;	//
};

#endif

